unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls,DB, DBTables,DACMgr, TabNotBk, ExtCtrls, Grids,
	DBGrids, ComCtrls;

type
  TForm1 = class(TForm)
    VSSecurity1: TDACManager;
    SecurityObject1: TSecurityObject;
    TabbedNotebook1: TTabbedNotebook;
    Memo1: TMemo;
    LogOnBtn: TButton;
    MaintenanceBtn: TButton;
		PINBtn: TButton;
    BuildBtn: TButton;
    Form1Btn: TButton;
    Form2Btn: TButton;
    Form3Btn: TButton;
    Form4Btn: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
		Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
		Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Button1: TButton;
    Panel1: TPanel;
		CurrentUser: TLabel;
    Label17: TLabel;
    SecurityLog: TTable;
    DataSource1: TDataSource;
		DBGrid1: TDBGrid;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
		procedure LogOnBtnClick(Sender: TObject);
		procedure MaintenanceBtnClick(Sender: TObject);
		procedure PINBtnClick(Sender: TObject);
    procedure VSSecurity1BuildDAO(Sender: TObject);
		procedure BuildBtnClick(Sender: TObject);
		procedure Form1BtnClick(Sender: TObject);
		procedure Form2BtnClick(Sender: TObject);
		procedure Form3BtnClick(Sender: TObject);
		procedure Form4BtnClick(Sender: TObject);
    procedure VSSecurity1DACMEvent(const EventType: TSecurityEvents;
			Info1: Longint; Info2: Byte);
		procedure SecurityObject1Permissions(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.LogOnBtnClick(Sender: TObject);
begin
Security.LogOn;
if Security.LoggedOn=True then caption:='Logged On' else caption:='LogOn Failed';
end;

procedure TForm1.MaintenanceBtnClick(Sender: TObject);
begin
Security.Maintenance;
end;

procedure TForm1.PINBtnClick(Sender: TObject);
begin
Security.ChangePIN;

end;

procedure TForm1.VSSecurity1BuildDAO(Sender: TObject);
var
OID:longint;
begin
Security.AppendObject('New Form','FormX',OID);

end;

procedure TForm1.BuildBtnClick(Sender: TObject);
var
OID:longint;
begin
Security.AppendObject('Form1','Form1',OID);
Security.AppendObject('Form2','Form2',OID);
Security.AppendObject('Form5','Form5',OID);
Security.AppendObject('Form4','Form4',OID);

end;

procedure TForm1.Form1BtnClick(Sender: TObject);
var
p:TPermissions;
begin
p:=Security.CheckPermissions('Form1');
if []   = p then caption:='Access Denied - You have no permissions'
	else if ( p * [0,1,2,3,4]=[0,1,2,3,4])  then caption:='Access Granted - You have Read permissions'
		else caption:='Access Denied - You do not have the right permissions'

end;

procedure TForm1.Form2BtnClick(Sender: TObject);
var
p:TPermissions;
begin
p:=Security.CheckPermissions('Form2');
if [] = p then caption:='Access Denied - You have no permissions'
	else if 0 in p then caption:='Access Granted - You have Read permissions'
		else caption:='Access Denied - You do not have the right permissions'

end;

procedure TForm1.Form3BtnClick(Sender: TObject);
var
p:TPermissions;
begin
p:=Security.CheckPermissions('Form3');
if [] = p then caption:='Access Denied - You have no permissions'
	else if 2 in p then caption:='Access Granted - You have Modify permissions'
		else caption:='Access Denied - You do not have the right permissions'

end;

procedure TForm1.Form4BtnClick(Sender: TObject);
var
p:TPermissions;
begin
p:=Security.CheckPermissions('Form4');
if [] = p then caption:='Access Denied - You have no permissions'
	else if 2 in p then caption:='Access Granted - You have Modify permissions'
		else caption:='Access Denied - You do not have the right permissions'

end;

procedure TForm1.VSSecurity1DACMEvent(const EventType: TSecurityEvents;
	Info1: Longint; Info2: Byte);
var
EType:string;
begin
if EventType=sLogOn then CurrentUser.Caption:='Current User: '+Security.UserName;
case EventType of
sLogOn:EType:='LoggedOn';
sPermissions:EType:='Permission Check';
sPINChange:EType:='PINChange';
sMaintenance:EType:='Maintenance';
sWrite:EType:='Writing Security Record';
sOList:EType:='Updating Permissions';
sDelete:EType:='Deleting Security Record';
end;
Panel1.Caption:='LastEvent: ' + EType;
if SecurityLog.Active<>True then SecurityLog.Active:=True;
with SecurityLog do
begin
AppendRecord([Security.UserName,EType,Now,Info1,Info2]);
end;
end;

procedure TForm1.SecurityObject1Permissions(Sender: TObject);
begin
if TSecurityObject(Sender).Permissions=[] then
ShowMessage('The DACM has reported you have no permissions for this application, however you can continue for the moment');
end;

end.
